<div class="page-content-wrapper">
    <div class="page-content all">
        <div class="row">
            <div class="col-md-12">


                <div class="portlet box blue light portlet-fit bordered">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class=" icon-layers "></i>
                            <span class="caption-subject bold">Growth Chart</span>
                        </div>
                        <div class="actions">
                            <a href="javascript:" class="btn btn-default btn-xs" id="growth_add">
                                Add New</a>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <table class="table">
                            <tbody>
                            <tr>
                                <th colspan="4" style="text-align: center;">
                                    Patient information
                                </th>
                            </tr>
                            <tr>
                                <td>
                                    <label>
                                        Date of birth: {$patientdata.dateofbirth}
                                    </label>
                                </td>
                                <td>
                                    <label>
                                        Age now: {$patient_age}
                                    </label>
                                </td>
                                <td>
                                    <label>
                                        Gender: {if $patientdata.gender eq 0} ذكر {else} انثي {/if}
                                    </label>
                                </td>
                                <td>
                                    <a href="" class="btn btn-sm green"> Refresh Charts
                                        <i class="fa fa-refresh"></i>
                                    </a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <table class="table table-striped table-hover table-bordered" id="growth_container">
                            <thead>
                            <tr>
                                <th class="col-md-2 wds12">
                                    Date
                                </th>
                                <th style="width: 20%;">
                                    Height/Length(cm)
                                </th>
                                <th style="width: 20%;">
                                    Weight(kg)
                                </th>
                                <th style="width: 20%;">
                                    Head(cm)
                                </th>
                                <th style="width: 20%;">
                                    BMI
                                </th>
                                <th style="width: 5px;">
                                    Delete
                                </th>
                            </tr>
                            </thead>
                            <tbody id="">
                            {foreach $growth_data as $growth_obj}
                                <tr>
                                    <td>
                                        <input type="text" class="form-control updateElement datepicker" data-id="{$growth_obj->id}" data-colName="growth_date" data-tableName="growth"
                                               value="{$growth_obj->growth_date}"/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control calc_bmi updateElement" id="length_{$growth_obj->id}" data-id="{$growth_obj->id}" data-colName="length"
                                               data-tableName="growth" value="{$growth_obj->length}"/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control calc_bmi updateElement" id="weight_{$growth_obj->id}" data-id="{$growth_obj->id}" data-colName="weight"
                                               data-tableName="growth" value="{$growth_obj->weight}"/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control updateElement" data-id="{$growth_obj->id}" data-colName="head" data-tableName="growth" value="{$growth_obj->head}"/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control updateElement" id="bmi_{$growth_obj->id}" data-id="{$growth_obj->id}" readonly data-colName="bmi" data-tableName="growth"
                                               value="{$growth_obj->bmi}"/>
                                    </td>
                                    <td>
                                        <a class="btn grey-cascade btn-xs deletemsgEX" data-id="{$growth_obj->id}" style=" float: left;" href="javascript:" data-link="growth_chart"
                                           data-tableName="growth" data-fn="del">
                                            <i class="fa fa-close"></i>
                                        </a>
                                    </td>
                                </tr>
                            {/foreach}
                            </tbody>
                        </table>
                        <div class="growth_chart_tab tabbable-custom nav-justified">
                            <ul class="nav nav-tabs nav-justified" id="growth_tab">
                                <li class="active">
                                    <a href="#tab_cdc" data-name="cdc" data-toggle="tab" aria-expanded="true"> CDC</a>
                                </li>
                                <li class="">
                                    <a href="#tab_who" data-name="who" data-toggle="tab" aria-expanded="false"> WHO</a>
                                </li>
{*                                <li class="">*}
{*                                    <a href="#tab_other" data-name="other" data-toggle="tab" aria-expanded="false"> OTHER </a>*}
{*                                </li>*}
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab_cdc">
                                    <div class="row">

                                        {if $patientdata.gender eq 0}
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Height for Age 2 - 20 years old (Boys)</span>
                                                <div id="cdc_boy_height_20" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Weight for Age 2 - 20 years old (Boys)</span>
                                                <div id="cdc_boy_weight_20" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-12">
                                                <span class="caption-subject font-blue bold uppercase">BMI for Age 2 - 20 years old (Boys)</span>
                                                <div id="cdc_boy_bmi_20" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                        {else}
                                            <div class="col-md-6">
                                                <span class="caption-subject font-red-pink bold uppercase">Height for Age 2 - 20 years old (Girls)</span>
                                                <div id="cdc_girl_height_20" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <span class="caption-subject font-red-pink bold uppercase">Weight for Age 2 - 20 years old (Girls)</span>
                                                <div id="cdc_girl_weight_20" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-12">
                                                <span class="caption-subject font-red-pink bold uppercase">BMI for Age 2 - 20 years old (Girls)</span>
                                                <div id="cdc_girl_bmi_20" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                        {/if}
                                    </div>
                                </div>
                                <div class="tab-pane" id="tab_who">
                                    <div class="row">

                                        {if $patientdata.gender eq 0}
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Weight for Length 45 - 110 cm tall (Boys)</span>
                                                <div id="who_boy_wh_0" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Head Circumference for age 0 - 24 month (Boys)</span>
                                                <div id="who_boy_head_0" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Length for age < 24 Months (Boys)</span>
                                                <div id="who_boy_length_age_0" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Weight for age < 24 Months (Boys)</span>
                                                <div id="who_boy_weight_age_0" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>

                                        {else}
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Weight for Length 45 - 110 cm tall (Girls)</span>
                                                <div id="who_girl_wh_0" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Head Circumference for age 0 - 24 month (Girls)</span>
                                                <div id="who_girl_head_0" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>

                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Length for age < 24 Months (Girls)</span>
                                                <div id="who_girl_length_age_0" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                            <div class="col-md-6">
                                                <span class="caption-subject font-blue bold uppercase">Weight for age < 24 Months (Girls)</span>
                                                <div id="who_girl_weight_age_0" class="chart growth_chart" style="height: 600px;"></div>
                                            </div>
                                        {/if}
                                    </div>
                                </div>
{*                                <div class="tab-pane" id="tab_other">*}
{*                                    <h4>others chart</h4>*}
{*                                </div>*}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<input type="hidden" id="patientId" value="{$patientid}"/>
<input type="hidden" id="controllName" value="growth_chart"/>

<div class="hidden" id="cdc_height_data">
    {$growth_chart_data.height}
</div>
<div class="hidden" id="cdc_weight_data">
    {$growth_chart_data.weight}
</div>
<div class="hidden" id="cdc_bmi_data">
    {$growth_chart_data.bmi}
</div>

<div class="hidden" id="who_length_weight_data">
    {$growth_chart_data.length_weight}
</div>
<div class="hidden" id="who_age_head_data">
    {$growth_chart_data.age_head}
</div>
<div class="hidden" id="who_age_length_data">
    {$growth_chart_data.age_length}
</div>
<div class="hidden" id="who_age_weight_data">
    {$growth_chart_data.age_weight}
</div>


<style>
    .growth_chart .legend {
        position: absolute;
        left: 121px;
    }

    .growth_chart_tab .nav-tabs > li.active > a, .growth_chart_tab .nav-tabs > li.active > a:focus, .growth_chart_tab .nav-tabs > li.active > a:hover {
        color: #342d2d;
    }

    .growth_chart_tab .tab-content > .tab-pane:not(.active),
    .growth_chart_tab .pill-content > .pill-pane:not(.active) {
        display: block;
        height: 0;
        overflow-y: hidden;
    }

    .table td label {
        vertical-align: -webkit-baseline-middle;
    }
</style>