<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */
require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct() {
	require_once("../public/aw_config.php");
	require_once("imp/_autho.php"); //general functions
	$this->smarty = $smarty;
	$this->hosturl = $hosturl;

	//here name of controll to known
	$this->controllname = 'ultrasoundobst';
	$this->shcontrollname = 'ultrasoundobst';
	$this->smarty->assign('controllname', $this->controllname);
	$this->smarty->assign('shcontrollname', $this->shcontrollname);

	//breadcrumbs
	require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
	$acty = filter_input(INPUT_GET, 'ac');
	$bc = new breadcrumbs($hosturl, '', '', $acty);
	$bc->crumbs();
	$breadcrumbs = $bc->breadcrumbs;
	$smarty->assign('breadcrumbs', $breadcrumbs);

	# here show the active page in menu
	// array called active[] with level of active element
	$active[0] = 'Investigations'; //controller name or tab name
	$this->active = $active;


	//here will call all php pages
	require_once("_header.php");
	require_once("_patientdata.php");
	require_once("_sidebar.php");
	require_once("_leftsidebar.php");
	require_once("_footer.php");
	$this->patientid = patientdata::patientid();
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
	//here will load the menu show
	$doctorid = $_SESSION['user_id'];
	$doctorData = R::getRow('select * from awusers where user_id = ' . $doctorid);
	$this->smarty->assign('doctorData', $doctorData);

	$ProgramesettingData = R::findone('programesetting');
	$this->smarty->assign('ProgramesettingData', $ProgramesettingData);

	$today = date("Y-m-d");
	$this->smarty->assign('today', $today);

	$patientid = filter_input(INPUT_GET, "patientid");
	if (empty($this->patientid)) {
	    header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
	    exit();
	}

	$allultra = R::findAll('ultrasoundobst', 'patientid = ? and del = 0 and done = 1', [$patientid]);
	foreach ($allultra as $data) {
	    $patientData = R::load("patients", $data->patientid);
	    $data->pname = $patientData->wifename;
	}

	//$patientid = 1;
	$this->smarty->assign('allultra', $allultra);
	$this->smarty->assign('patientid', $this->patientid);

	$patientData = R::load("patients", $patientid);


	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasoundobst/show.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function show() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$patientId = filter_input(INPUT_GET, "patientid");

	$patientData = R::load("patients", $patientId);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$id = filter_input(INPUT_GET, "id");

	$allSono = R::getAll('select * from awusers where positionid = 4');
	//$allSup = R::getAll('select * from awusers where positionid = 5');

	$ultrasoundobstData = R::load('ultrasoundobst', $id);
	$ultrasoundobstDetail = R::findAll('ultrasoundobstdetail', 'ultrasoundobstid = ? and del = 0', [$ultrasoundobstData->id]);

	$ultrasoundobstData->edate = date('Y/m/d', strtotime($ultrasoundobstData->edate));
	/* if($ultrasoundobstData->stype == 0)
	  {

	  }
	  else
	  {
	  $this->smarty->assign('allSname',$allSup);
	  } */

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->assign('ultrasoundobstData', $ultrasoundobstData);
	$this->smarty->assign('ultrasoundobstDetail', $ultrasoundobstDetail);
	$this->smarty->assign('detailCount', count($ultrasoundobstDetail));

	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasoundobst/add.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$patientId = filter_input(INPUT_GET, "patientid");

	$patientData = R::load("patients", $patientId);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$allSono = R::getAll('select * from awusers where positionid = 4');
	$allSup = R::getAll('select * from awusers where positionid = 5');

	$ultrasoundobstData = R::findOne('ultrasoundobst', 'patientid = ? and del = 0 order by id desc limit 1', [$patientId]);
	$ultrasoundobstDetail;
	if (empty($ultrasoundobstData) || $ultrasoundobstData->done == 1) {
	    $today = date("Y/m/d");

	    $ultrasoundobst = R::dispense('ultrasoundobst');

	    $ultrasoundobst->patientid = $patientId;
	    $ultrasoundobst->del = 0;
	    $ultrasoundobst->done = 0;
	    $ultrasoundobst->edate = $today;
	    //$ultrasoundobst->stype = 0;
	    $ultrasoundobst->sid = 0;
	    $ultrasoundobst->tcondition = 0;
	    $ultrasoundobst->babyno = 1;

	    $id = R::store($ultrasoundobst);

	    $ultrasoundobstData = R::load('ultrasoundobst', $id);

	    $ultrasoundobstDetail = R::dispense("ultrasoundobstdetail");

	    $ultrasoundobstDetail->del = 0;
	    $ultrasoundobstDetail->ultrasoundobstid = $id;
	    $ultrasoundobstDetail->appearance = 0;

	    $ultrasoundobstDetail->shape = 0;
	    $ultrasoundobstDetail->cranial = 0;
	    $ultrasoundobstDetail->falx = 0;
	    $ultrasoundobstDetail->choroid = 0;

	    $ultrasoundobstDetail->profile = 0;
	    $ultrasoundobstDetail->orbits = 0;

	    $ultrasoundobstDetail->neck = 0;

	    $ultrasoundobstDetail->pulm = 0;
	    $ultrasoundobstDetail->diaphragm = 0;

	    $ultrasoundobstDetail->heart = 0;
	    $ultrasoundobstDetail->heartactivity = 0;
	    $ultrasoundobstDetail->hsize = 0;
	    $ultrasoundobstDetail->haxix = 0;
	    $ultrasoundobstDetail->chamberview = 0;

	    $ultrasoundobstDetail->stomach = 0;
	    $ultrasoundobstDetail->bowel = 0;
	    $ultrasoundobstDetail->kidney = 0;
	    $ultrasoundobstDetail->bladder = 0;
	    $ultrasoundobstDetail->cordinsertion = 0;
	    $ultrasoundobstDetail->cordvessels = 0;

	    $ultrasoundobstDetail->spine = 0;

	    $ultrasoundobstDetail->rarm = 0;
	    $ultrasoundobstDetail->rleg = 0;
	    $ultrasoundobstDetail->larm = 0;
	    $ultrasoundobstDetail->lleg = 0;

	    $ultrasoundobstDetail->gender = -1;
	    $ultrasoundobstDetail->gendern = 0;

	    $ultrasoundobstDetail->conclusion = 0;
	    $ultrasoundobstDetail->plans = 0;

	    $detailid = R::store($ultrasoundobstDetail);

	    $ultrasoundobstDetail = R::findAll('ultrasoundobstdetail', 'ultrasoundobstid = ? and del = 0', [$id]);
	} else {
	    $ultrasoundobstData = R::findOne('ultrasoundobst', 'patientid = ? and del =0 order by id desc limit 1', [$patientId]);
	    $ultrasoundobstDetail = R::findAll('ultrasoundobstdetail', 'ultrasoundobstid = ? and del = 0', [$ultrasoundobstData->id]);
	}

	$ultrasoundobstData->edate = date('Y/m/d', strtotime($ultrasoundobstData->edate));
	/* if($ultrasoundobstData->stype == 0)
	  {
	  $this->smarty->assign('allSname',$allSono);
	  }
	  else
	  {
	  $this->smarty->assign('allSname',$allSup);
	  } */

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->assign('ultrasoundobstData', $ultrasoundobstData);
	$this->smarty->assign('ultrasoundobstDetail', $ultrasoundobstDetail);
	$this->smarty->assign('detailCount', count($ultrasoundobstDetail));

	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasoundobst/add.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function update() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");
	$value = filter_input(INPUT_POST, "value");
	$tableName = filter_input(INPUT_POST, "tableName");
	$colName = filter_input(INPUT_POST, "colName");
	$patientId = filter_input(INPUT_POST, "patientId");
	$dated = filter_input(INPUT_POST, "dated");

	if ($dated == 1) {
	    $value = date("Y-m-d", strtotime($value));
	}
	if ($tableName == "ultrasoundobstdetail") {
	    $mydata = R::load($tableName, $id);
	} else {
	    $mydata = R::findone($tableName, 'id = ? and patientid = ?', [$id, $patientId]);
	}
	$mydata->$colName = $value;
	R::store($mydata);
    }

    public function showdetails() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");

	$ultrasoundobstDetail = R::load('ultrasoundobstdetail', $id);
	$this->smarty->assign('ultrasoundobstDetail', $ultrasoundobstDetail);
	$this->smarty->display('ultrasoundobst/babymodel.html');
    }

    public function updateradio() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");
	$value = filter_input(INPUT_POST, "value");
	$tableName = filter_input(INPUT_POST, "tableName");
	$colName = filter_input(INPUT_POST, "colName");


	$mydata = R::load($tableName, $id);
	$mydata->$colName = $value;
	R::store($mydata);

	/* if($colName == "stype")
	  {
	  $mydata = R::load($tableName, $id);
	  $mydata->sid = 0;
	  R::store($mydata);

	  $position;
	  if($value == 0)
	  {
	  $positin = 4;

	  }
	  if ($value == 1)
	  {
	  $positin = 5;
	  }
	  $allSname = R::getAll('select * from awusers where positionid = '.$positin);
	  }
	  $this->smarty->assign('allSname',$allSname);
	  $this->smarty->assign('id',$id);
	  $this->smarty->display('ultrasoundobst/selects.html'); */
    }

    public function addDeteail() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");

	$ultrasoundobstDetail = R::dispense("ultrasoundobstdetail");

	$ultrasoundobstDetail->del = 0;
	$ultrasoundobstDetail->ultrasoundobstid = $id;
	$ultrasoundobstDetail->appearance = 0;

	$ultrasoundobstDetail->shape = 0;
	$ultrasoundobstDetail->cranial = 0;
	$ultrasoundobstDetail->falx = 0;
	$ultrasoundobstDetail->choroid = 0;

	$ultrasoundobstDetail->profile = 0;
	$ultrasoundobstDetail->orbits = 0;

	$ultrasoundobstDetail->neck = 0;

	$ultrasoundobstDetail->pulm = 0;
	$ultrasoundobstDetail->diaphragm = 0;

	$ultrasoundobstDetail->heart = 0;
	$ultrasoundobstDetail->heartactivity = 0;
	$ultrasoundobstDetail->hsize = 0;
	$ultrasoundobstDetail->haxix = 0;
	$ultrasoundobstDetail->chamberview = 0;

	$ultrasoundobstDetail->stomach = 0;
	$ultrasoundobstDetail->bowel = 0;
	$ultrasoundobstDetail->kidney = 0;
	$ultrasoundobstDetail->bladder = 0;
	$ultrasoundobstDetail->cordinsertion = 0;
	$ultrasoundobstDetail->cordvessels = 0;

	$ultrasoundobstDetail->spine = 0;

	$ultrasoundobstDetail->rarm = 0;
	$ultrasoundobstDetail->rleg = 0;
	$ultrasoundobstDetail->larm = 0;
	$ultrasoundobstDetail->lleg = 0;

	$ultrasoundobstDetail->gender = -1;
	$ultrasoundobstDetail->gendern = 0;

	$ultrasoundobstDetail->conclusion = 0;
	$ultrasoundobstDetail->plans = 0;

	$detailid = R::store($ultrasoundobstDetail);
	echo $detailid;
    }

    public function delData() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_GET, "id");
	$tableName = filter_input(INPUT_GET, "tableName");
	$patientid = filter_input(INPUT_GET, "patientid");

	$myData = R::load($tableName, $id);
	$myData->del = 1;
	$myid = R::store($myData);

	$ultrasoundobst = R::load('ultrasoundobst', $myData->ultrasoundobstid);
	$no = $ultrasoundobst->babyno;
	$no = --$no;
	$ultrasoundobst->babyno = $no;
	R::store($ultrasoundobst);

	if ($ultrasoundobst->done == 0)
	    header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=add&patientid=' . $patientid);
	else
	    header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid . '&id=' . $ultrasoundobst->id);
    }

    public function delRow() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_GET, "id");
	$patientid = filter_input(INPUT_GET, "patientid");

	$myData = R::load('ultrasoundobst', $id);
	$myData->del = 1;
	$myid = R::store($myData);

	header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?patientid=' . $patientid);
    }

    public function showprint() {

	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$doctorid = $_SESSION['user_id'];
	$doctorData = R::getRow('select * from awusers where user_id = ' . $doctorid);
	$this->smarty->assign('doctorData', $doctorData);


	$id = filter_input(INPUT_POST, "id");
	$patientid = filter_input(INPUT_POST, "patientid");

	$ultrasoundobstDetail = R::load('ultrasoundobstdetail', $id);
	$this->smarty->assign('ultrasoundobstDetail', $ultrasoundobstDetail);
	$ultrasoundobstData = R::load('ultrasoundobst', $ultrasoundobstDetail->ultrasoundobstid);
	$this->smarty->assign('ultrasoundobstData', $ultrasoundobstData);

	$ProgramesettingData = R::findone('programesetting');
	$this->smarty->assign('ProgramesettingData', $ProgramesettingData);

	$patientData = R::load("patients", $patientid);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$allSono = R::getAll('select * from awusers where positionid = 4');
	//$allSup = R::getAll('select * from awusers where positionid = 5');

	$ultrasoundobstData->edate = date('Y/m/d', strtotime($ultrasoundobstData->edate));
	/* if ($ultrasoundobstData->stype == 0) {
	  $this->smarty->assign('allSname', $allSono);
	  } else {
	  $this->smarty->assign('allSname', $allSup);
	  } */

	$mydata = R::load('ultrasoundobst', $ultrasoundobstData->id);

	$mydata->done = 1;
	R::store($mydata);

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->display('ultrasoundobst/print.html');
    }

    public function onesetup() {

	//check login
	autho::checkautho($this->hosturl);

	try {
	    //delete all but with only default
	    #1 clean roles only managment
	    #2 clean menu only default
	    #3 clean controls only default
	    #4 users clean users
	    #delete all menus
	    $menus = R::findAll('awmenu', 'id > 15');
	    #delete from awrolemenu
	    foreach ($menus as $one) {
		//get propes
		$rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
		R::trashAll($rolemenu);
	    }
	    R::trashAll($menus);
	    #delete controles
	    $controlls = R::findAll('awcontroll', 'id > 4 and id < 18');
	    foreach ($controlls as $one) {
		//get propes
		$inprop = R::findAll('awcontrollprop', 'awcontroll_id = ?', [$one->id]);
		#delete from awrolecontroleprop
		foreach ($inprop as $one) {
		    //get propes
		    $roleprop = R::findAll('awrolecontrollprop', 'controllprop_id = ?', [$one->id]);
		    R::trashAll($roleprop);
		}
		R::trashAll($inprop);
	    }
	    R::trashAll($controlls);
	    #delete othre roles
	    $roles = R::findAll('awrole', 'id > 1');
	    R::trashAll($roles);
	    #delete other users
	    //$users = R::findAll('awusers', 'user_id > 1');
	    //R::exec('Delete from awusers where user_id > 1');
	    //R::trashAll($users);
	    ############################
	    //new one
	    $menusx = R::findAll('awmenu', ' id = 4 or id = 5 or id = 7 or id = 8 or id = 10 or id = 11 or id = 13 or id = 14 or id = 15 ');
	    #delete from awrolemenu
	    foreach ($menusx as $one) {
		//get propes
		$rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
		R::trashAll($rolemenu);
	    }
	    R::trashAll($menusx);

	    print_r('trash all , install is good');
	} catch (Exception $ex) {
	    print_r('something go wrong  , try again');
	}
    }

    // at the end of class call
    public function __destruct() {
	//close connection
	R::close();
    }

}
