<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */
require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'investigation';
        $this->shcontrollname = 'Home';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'Investigations'; //controller name or tab name
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
        $this->patientid = patientdata::patientid();
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $doctorid = $_SESSION['user_id'];
        $doctorData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $this->smarty->assign('doctorData',$doctorData);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);
        
        $today = date("d-m-Y");
        $this->smarty->assign('today', $today);

        $patientid = filter_input(INPUT_GET, "patientid");
        if(empty($this->patientid))
        {
             header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        
        
        //$patientid = 1;
        $this->smarty->assign('patientid', $this->patientid);

        $allsemen = R::findAll('semen', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        if (empty($allsemen)) {
            $semenData = R::dispense('semen');
            $semenData->sdate = $today;
            $semenData->patientid = $patientid;
            $semenData->doctorid = $doctorid;
            $semenData->del = 0;
            $semenid = R::store($semenData);

            $this->smarty->assign('semenid', $semenid);
        }
        $allsemen = R::findAll('semen', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        foreach ($allsemen as $data) {
            
            $data->sdate = date("d-m-Y", strtotime($data->sdate));
            
            $doctordata = R::getRow('select user_name from awusers where user_id = ' . $data->doctorid);
            $data->docname = $doctordata['user_name'];
        }
        $this->smarty->assign('allsemen', $allsemen);
        $this->smarty->assign('semencount', count($allsemen));


        $allhsg = R::findAll('hsg', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);

        if (empty($allhsg)) {
            $hsgData = R::dispense('hsg');
            $hsgData->sdate = $today;
            $hsgData->patientid = $this->patientid;
            $hsgData->doctorid = $doctorid;
            $hsgData->del = 0;
            $hsgid = R::store($hsgData);

            $this->smarty->assign('hsgid', $hsgid);
        }
        $allhsg = R::findAll('hsg', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        foreach ($allhsg as $data) {
            $data->sdate = date("d-m-Y", strtotime($data->sdate));
            
            $doctordata = R::getRow('select user_name from awusers where user_id = ' . $data->doctorid);
            $data->docname = $doctordata['user_name'];
        }
        $this->smarty->assign('allhsg', $allhsg);
        $this->smarty->assign('hsgcount', count($allhsg));

        $allustv = R::findAll('ustv', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        if (empty($allustv)) {
            $ustvData = R::dispense('ustv');
            $ustvData->sdate = $today;
            $ustvData->patientid = $this->patientid;
            $ustvData->doctorid = $doctorid;
            $ustvData->del = 0;
            $ustvid = R::store($ustvData);

            $this->smarty->assign('ustvid', $ustvid);
        }
        $allustv = R::findAll('ustv', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        foreach ($allustv as $data) {
            $data->sdate = date("d-m-Y", strtotime($data->sdate));
            
            $doctordata = R::getRow('select user_name from awusers where user_id = ' . $data->doctorid);
            $data->docname = $doctordata['user_name'];
        }
        $this->smarty->assign('allustv', $allustv);
        $this->smarty->assign('ustvcount', count($allustv));

        $alllaparoscopy = R::findAll('laparoscopy', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        if (empty($alllaparoscopy)) {
            $lapData = R::dispense('laparoscopy');
            $lapData->sdate = $today;
            $lapData->patientid = $this->patientid;
            $lapData->doctorid = $doctorid;
            $lapData->del = 0;
            $lapid = R::store($lapData);

            $this->smarty->assign('lapid', $lapid);
        }
        $alllaparoscopy = R::findAll('laparoscopy', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        foreach ($alllaparoscopy as $data) {
            $data->sdate = date("d-m-Y", strtotime($data->sdate));
            
            $doctordata = R::getRow('select user_name from awusers where user_id = ' . $data->doctorid);
            $data->docname = $doctordata['user_name'];
        }
        $this->smarty->assign('alllaparoscopy', $alllaparoscopy);
        $this->smarty->assign('lapcount', count($alllaparoscopy));

        $allhysteroscopy = R::findAll('hysteroscopy', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        if (empty($allhysteroscopy)) {
            $hystData = R::dispense('hysteroscopy');
            $hystData->sdate = $today;
            $hystData->patientid = $this->patientid;
            $hystData->doctorid = $doctorid;
            $hystData->del = 0;
            $hystid = R::store($hystData);

            $this->smarty->assign('hystid', $hystid);
        }
        $allhysteroscopy = R::findAll('hysteroscopy', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        foreach ($allhysteroscopy as $data) {
            $data->sdate = date("d-m-Y", strtotime($data->sdate));
            
            $doctordata = R::getRow('select user_name from awusers where user_id = ' . $data->doctorid);
            $data->docname = $doctordata['user_name'];
        }
        $this->smarty->assign('allhysteroscopy', $allhysteroscopy);
        $this->smarty->assign('hystcount', count($allhysteroscopy));

        $allmrict = R::findAll('mrict', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        if (empty($allmrict)) {
            $mriData = R::dispense('mrict');
            $mriData->sdate = $today;
            $mriData->patientid = $this->patientid;
            $mriData->doctorid = $doctorid;
            $mriData->del = 0;
            $mrid = R::store($mriData);

            $this->smarty->assign('mrid', $mrid);
        }
        $allmrict = R::findAll('mrict', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        foreach ($allmrict as $data) {
            $data->sdate = date("d-m-Y", strtotime($data->sdate));
            
            $doctordata = R::getRow('select user_name from awusers where user_id = ' . $data->doctorid);
            $data->docname = $doctordata['user_name'];
        }
        $this->smarty->assign('allmrict', $allmrict);
        $this->smarty->assign('mricount', count($allmrict));

        $allpathology = R::findAll('pathology', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        if (empty($allpathology)) {
            $pathData = R::dispense('pathology');
            $pathData->sdate = $today;
            $pathData->patientid = $this->patientid;
            $pathData->doctorid = $doctorid;
            $pathData->del = 0;
            $pathid = R::store($pathData);

            $this->smarty->assign('pathid', $pathid);
        }
        $allpathology = R::findAll('pathology', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        foreach ($allpathology as $data) {
            $data->sdate = date("d-m-Y", strtotime($data->sdate));
            
            $doctordata = R::getRow('select user_name from awusers where user_id = ' . $data->doctorid);
            $data->docname = $doctordata['user_name'];
        }
        $this->smarty->assign('allpathology', $allpathology);
        $this->smarty->assign('pathcount', count($allpathology));

        $allhormon = R::findAll('hormon', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        if (empty($allhormon)) {
            $hormonData = R::dispense('hormon');
            $hormonData->sdate = $today;
            $hormonData->patientid = $this->patientid;
            $hormonData->doctorid = $doctorid;
            $hormonData->del = 0;
            $hormonid = R::store($hormonData);

            $this->smarty->assign('hormonid', $hormonid);
        }
        $allhormon = R::findAll('hormon', 'patientid = ? and del = 0 order by sdate desc, id desc', [$this->patientid]);
        foreach ($allhormon as $data) {
            $data->sdate = date("d-m-Y", strtotime($data->sdate));
            
            $doctordata = R::getRow('select user_name from awusers where user_id = ' . $data->doctorid);
            $data->docname = $doctordata['user_name'];
        }
        $this->smarty->assign('allhormon', $allhormon);
        $this->smarty->assign('hormoncount', count($allhormon));


        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        //$this->smarty->display('investigation/investigation.html');
        $this->smarty->display('investigation/investigation1.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addRow() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $doctorid = $_SESSION['user_id'];

        $today = date("d-m-Y");
        $patientid = filter_input(INPUT_POST, "patientId");
        $tableName = filter_input(INPUT_POST, "tableName");

        $semenData = R::dispense($tableName);
        $semenData->sdate = date("Y-m-d", strtotime($today));
        $semenData->patientid = $patientid;
        $semenData->doctorid = $doctorid;
        $semenData->del = 0;
        $semenid = R::store($semenData);

        echo $semenid;
    }

    public function delData() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, "id");
        $tableName = filter_input(INPUT_GET, "tableName");
        $patientid = filter_input(INPUT_GET, "patientid");

        $myData = R::load($tableName, $id);
        $myData->del = 1;
        $myid = R::store($myData);

        header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?patientid='. $patientid);
    }

    public function update() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $value = filter_input(INPUT_POST, "value");
        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");
        $patientId = filter_input(INPUT_POST, "patientId");
        $dated = filter_input(INPUT_POST, "dated");
        
        if($dated == 1)
        {
            $value = date("Y-m-d", strtotime($value));
        }

        $mydata = R::findone($tableName, 'id = ? and patientid = ?', [$id, $patientId]);
        $mydata->$colName = $value;
        R::store($mydata);
    }

    public function onesetup() {

        //check login
        autho::checkautho($this->hosturl);

        try {
            //delete all but with only default
            #1 clean roles only managment
            #2 clean menu only default
            #3 clean controls only default
            #4 users clean users
            #delete all menus
            $menus = R::findAll('awmenu', 'id > 15');
            #delete from awrolemenu
            foreach ($menus as $one) {
                //get propes
                $rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
                R::trashAll($rolemenu);
            }
            R::trashAll($menus);
            #delete controles
            $controlls = R::findAll('awcontroll', 'id > 4 and id < 18');
            foreach ($controlls as $one) {
                //get propes
                $inprop = R::findAll('awcontrollprop', 'awcontroll_id = ?', [$one->id]);
                #delete from awrolecontroleprop
                foreach ($inprop as $one) {
                    //get propes
                    $roleprop = R::findAll('awrolecontrollprop', 'controllprop_id = ?', [$one->id]);
                    R::trashAll($roleprop);
                }
                R::trashAll($inprop);
            }
            R::trashAll($controlls);
            #delete othre roles
            $roles = R::findAll('awrole', 'id > 1');
            R::trashAll($roles);
            #delete other users
            //$users = R::findAll('awusers', 'user_id > 1');
            //R::exec('Delete from awusers where user_id > 1');
            //R::trashAll($users);
            ############################
            //new one
            $menusx = R::findAll('awmenu', ' id = 4 or id = 5 or id = 7 or id = 8 or id = 10 or id = 11 or id = 13 or id = 14 or id = 15 ');
            #delete from awrolemenu
            foreach ($menusx as $one) {
                //get propes
                $rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
                R::trashAll($rolemenu);
            }
            R::trashAll($menusx);

            print_r('trash all , install is good');
        } catch (Exception $ex) {
            print_r('something go wrong  , try again');
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
