<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'risktype';
        $this->shcontrollname = 'risktype';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'risktype'; //controller name or tab name
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show

        $today = date("Y-m-d");
        $this->smarty->assign('today', $today);

        /* $allData = R::findAll('mainantenental', 'eed=?', [$today]);
          $this->smarty->assign('allData', $allData);
          foreach ($allData as $data) {
          $data->info = R::load('patients', $data->patientid);
          } */
        $allphobstericterminate = R::findall('phobstericterminate', 'del = 0');
        $this->smarty->assign('allphobstericterminate', $allphobstericterminate);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('reports/risktype.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function search() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $risktype = filter_input(INPUT_POST, 'risktype');
        //$allobsteric = R::findall('patients', 'del = ? and obstermination = ? order by obsdate desc, id DESC', [0, $termtype]);
        $userData = R::getAll('select id,wifename,husdandname,statusno,risk from patients where risktype = ' . $risktype . ' AND patients.deleted = 0 ');



        $this->smarty->assign('allData', $userData);
        $this->smarty->display('reports/risktypesearch.html');
    }
    
    public function showprint() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $risktype = filter_input(INPUT_POST, 'risktype');
        //$allobsteric = R::findall('patients', 'del = ? and obstermination = ? order by obsdate desc, id DESC', [0, $termtype]);
        $userData = R::getAll('select id,wifename,husdandname,statusno,risk from patients where risktype = ' . $risktype . ' AND patients.deleted = 0 ');



        $this->smarty->assign('allData', $userData);
        $this->smarty->display('reports/riskprint.html');
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
